<?php
// /api/chats.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            $sql = "SELECT * FROM Chats";
            $params = [];
            if (isset($_GET['id'])) {
                $sql .= " WHERE id = ?";
                $params[] = $_GET['id'];
            } elseif (isset($_GET['trip_id'])) {
                // Muy útil para encontrar el chat de un viaje específico
                $sql .= " WHERE trip_id = ?";
                $params[] = $_GET['trip_id'];
            }
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            $result = isset($_GET['id']) || isset($_GET['trip_id']) ? $stmt->fetch() : $stmt->fetchAll();
            if ($result) {
                echo json_encode($result);
            } else {
                http_response_code(404);
                echo json_encode(['message' => 'Chat no encontrado.']);
            }
            break;

        case 'POST':
            // Un chat se crea automáticamente cuando hay una interacción,
            // por ejemplo, la primera reserva o mensaje.
            $data = getJsonInput();
            if (empty($data['trip_id'])) {
                http_response_code(400); echo json_encode(['message' => 'trip_id es requerido.']); exit();
            }
            $sql = "INSERT INTO Chats (trip_id) VALUES (?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$data['trip_id']]);
            http_response_code(201);
            echo json_encode(['message' => 'Chat creado.', 'id' => $pdo->lastInsertId()]);
            break;

        case 'PUT':
            // La columna last_message_at se podría actualizar con un trigger al insertar en Messages
            http_response_code(405);
            echo json_encode(['message' => 'El método PUT no es aplicable a esta tabla.']);
            break;

        case 'DELETE':
            // Los chats se eliminan en cascada si se borra el viaje (trip)
            if (!isset($_GET['id'])) { http_response_code(400); echo json_encode(['message' => 'ID no especificado.']); exit(); }
            $stmt = $pdo->prepare("DELETE FROM Chats WHERE id = ?");
            $stmt->execute([$_GET['id']]);
            echo json_encode(['message' => 'Chat eliminado.']);
            break;

        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>