<?php
// /api/db_config.php

// --- CONFIGURACIÓN DE LA BASE DE DATOS ---
// Reemplaza con tus propias credenciales. Se recomienda usar variables de entorno en producción.
define('DB_HOST', 'localhost');
define('DB_NAME', 'awelectricalatl_zahau');
define('DB_USER', 'awelectricalatl_admin');
define('DB_PASS', 'Amoroso123*');
define('DB_CHARSET', 'utf8mb4');

// --- OPCIONES DE PDO ---
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

// --- FUNCIÓN DE CONEXIÓN ---
function getDbConnection() {
    global $options;
    $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
    try {
        $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
    } catch (\PDOException $e) {
        http_response_code(500);
        // En producción, registra el error en un log en lugar de mostrarlo.
        echo json_encode(['error' => 'Error de conexión a la base de datos.', 'details' => $e->getMessage()]);
        exit();
    }
    return $pdo;
}

// --- HEADERS COMUNES PARA LA API ---
function setApiHeaders() {
    header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
    header("Access-Control-Max-Age: 3600");
    header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

    // Manejar solicitud pre-flight de OPTIONS
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
        http_response_code(200);
        exit();
    }
}

// --- FUNCIÓN PARA OBTENER DATOS DE ENTRADA ---
function getJsonInput() {
    return json_decode(file_get_contents('php://input'), true);
}