<?php
// /api/demand_applications.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            $sql = "SELECT * FROM Demand_Applications";
            $params = [];
            if (isset($_GET['demand_id'])) {
                $sql .= " WHERE demand_id = ?";
                $params[] = $_GET['demand_id'];
            } elseif (isset($_GET['driver_id'])) {
                $sql .= " WHERE driver_id = ?";
                $params[] = $_GET['driver_id'];
            }
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            echo json_encode($stmt->fetchAll());
            break;

        case 'POST':
            $data = getJsonInput();
            $sql = "INSERT INTO Demand_Applications (demand_id, driver_id, trip_id, message) VALUES (?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$data['demand_id'], $data['driver_id'], $data['trip_id'] ?? null, $data['message'] ?? null]);
            http_response_code(201);
            echo json_encode(['message' => 'Aplicación enviada.', 'id' => $pdo->lastInsertId()]);
            break;

        case 'PUT':
            if (!isset($_GET['id'])) { http_response_code(400); echo json_encode(['message' => 'ID no especificado.']); exit(); }
            $id = $_GET['id'];
            $data = getJsonInput();
            // Para que el pasajero acepte/rechace una aplicación
            $sql = "UPDATE Demand_Applications SET status = ? WHERE id = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$data['status'], $id]);
            // Si es 'accepted', se debería actualizar el Demand_Request y crear un Booking.
            echo json_encode(['message' => 'Aplicación actualizada.']);
            break;
            
        case 'DELETE':
            if (!isset($_GET['id'])) { http_response_code(400); echo json_encode(['message' => 'ID no especificado.']); exit(); }
            $stmt = $pdo->prepare("DELETE FROM Demand_Applications WHERE id = ?");
            $stmt->execute([$_GET['id']]);
            echo json_encode(['message' => 'Aplicación eliminada.']);
            break;

        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>