<?php
// /api/demand_request_applications.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            $sql = "SELECT * FROM Demand_Request_Applications";
            $params = [];
            if (isset($_GET['id'])) {
                $sql .= " WHERE id = ?";
                $params[] = $_GET['id'];
            } elseif (isset($_GET['request_id'])) {
                $sql .= " WHERE request_id = ?";
                $params[] = $_GET['request_id'];
            } elseif (isset($_GET['driver_id'])) {
                $sql .= " WHERE driver_id = ?";
                $params[] = $_GET['driver_id'];
            }
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            $result = isset($_GET['id']) ? $stmt->fetch() : $stmt->fetchAll();
            echo json_encode($result);
            break;

        case 'POST':
            $data = getJsonInput();
            if (empty($data['request_id']) || empty($data['driver_id']) || empty($data['trip_id'])) {
                http_response_code(400);
                echo json_encode(['message' => 'request_id, driver_id y trip_id son requeridos.']);
                exit();
            }
            $sql = "INSERT INTO Demand_Request_Applications (request_id, driver_id, trip_id, message, status) VALUES (?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $data['request_id'],
                $data['driver_id'],
                $data['trip_id'],
                $data['message'] ?? null,
                'pending' // El estado inicial es siempre 'pending'
            ]);
            http_response_code(201);
            echo json_encode(['message' => 'Aplicación a la demanda creada.', 'id' => $pdo->lastInsertId()]);
            break;

        case 'PUT':
            // Para que un pasajero acepte/rechace la aplicación de un conductor
            if (!isset($_GET['id'])) {
                http_response_code(400);
                echo json_encode(['message' => 'ID de aplicación no especificado.']);
                exit();
            }
            $id = $_GET['id'];
            $data = getJsonInput(); // Espera { "status": "accepted|rejected", "rejection_reason": "..." }
            
            if (empty($data['status'])) {
                http_response_code(400);
                echo json_encode(['message' => 'El campo "status" es requerido para la actualización.']);
                exit();
            }

            $sql = "UPDATE Demand_Request_Applications SET status = ?, rejection_reason = ? WHERE id = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $data['status'],
                $data['rejection_reason'] ?? null,
                $id
            ]);
            
            // Lógica de negocio adicional:
            // Si el estado es 'accepted', se debería crear una reserva (`Booking`)
            // y marcar el `Demand_Request` como 'fulfilled'.
            
            echo json_encode(['message' => 'Estado de la aplicación actualizado.']);
            break;

        case 'DELETE':
            // Permitir que un conductor retire su aplicación
            if (!isset($_GET['id'])) {
                http_response_code(400);
                echo json_encode(['message' => 'ID de aplicación no especificado.']);
                exit();
            }
            $stmt = $pdo->prepare("DELETE FROM Demand_Request_Applications WHERE id = ?");
            $stmt->execute([$_GET['id']]);
            echo json_encode(['message' => 'Aplicación eliminada.']);
            break;

        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>