<?php
// /api/demand_requests.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            $select_fields = "id, passenger_id, direction, origin_address, destination_address, ST_AsText(origin_coordinates) as origin_coordinates, ST_AsText(destination_coordinates) as destination_coordinates, desired_time, status";
            if (isset($_GET['id'])) {
                $stmt = $pdo->prepare("SELECT $select_fields FROM Demand_Requests WHERE id = ?");
                $stmt->execute([$_GET['id']]);
                $req = $stmt->fetch();
                if ($req) echo json_encode($req);
                else { http_response_code(404); echo json_encode(['message' => 'Solicitud de demanda no encontrada.']); }
            } else {
                // Listar solicitudes activas
                $sql = "SELECT $select_fields FROM Demand_Requests WHERE status IN ('open', 'active') AND expires_at > NOW()";
                $stmt = $pdo->query($sql);
                echo json_encode($stmt->fetchAll());
            }
            break;

        case 'POST':
            $data = getJsonInput();
            $expires_at = date('Y-m-d H:i:s', strtotime('+24 hours')); // Expira por defecto en 24h
            $sql = "INSERT INTO Demand_Requests (passenger_id, direction, origin_address, destination_address, origin_coordinates, destination_coordinates, desired_time, flexible_time_minutes, max_price, seats_needed, special_requirements, expires_at) VALUES (?, ?, ?, ?, ST_PointFromText(?), ST_PointFromText(?), ?, ?, ?, ?, ?, ?)";
            
            $origin_point = isset($data['origin_coordinates']) ? 'POINT(' . $data['origin_coordinates']['lng'] . ' ' . $data['origin_coordinates']['lat'] . ')' : null;
            $destination_point = isset($data['destination_coordinates']) ? 'POINT(' . $data['destination_coordinates']['lng'] . ' ' . $data['destination_coordinates']['lat'] . ')' : null;

            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $data['passenger_id'], $data['direction'], $data['origin_address'], $data['destination_address'],
                $origin_point, $destination_point, $data['desired_time'],
                $data['flexible_time_minutes'] ?? 30, $data['max_price'] ?? null,
                $data['seats_needed'] ?? 1, $data['special_requirements'] ?? null, $expires_at
            ]);
            http_response_code(201);
            echo json_encode(['message' => 'Solicitud de demanda creada.', 'id' => $pdo->lastInsertId()]);
            break;

        case 'PUT':
            if (!isset($_GET['id'])) { http_response_code(400); echo json_encode(['message' => 'ID no especificado.']); exit(); }
            $id = $_GET['id'];
            $data = getJsonInput();
            // Principalmente para cambiar estado a 'cancelled' o 'fulfilled'
            $sql = "UPDATE Demand_Requests SET status = ?, fulfilled_by_trip_id = ? WHERE id = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$data['status'], $data['fulfilled_by_trip_id'] ?? null, $id]);
            echo json_encode(['message' => 'Solicitud de demanda actualizada.']);
            break;

        case 'DELETE':
            // Se prefiere cambiar el estado a 'cancelled' con PUT
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido. Use PUT para cancelar.']);
            break;

        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>