<?php
// /api/driver_learned_routes.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    if ($method == 'GET') {
        $sql = "SELECT * FROM Driver_Learned_Routes";
        $params = [];

        // Permite filtrar las rutas aprendidas por un conductor específico
        if (isset($_GET['driver_id'])) {
            $sql .= " WHERE driver_id = ?";
            $params[] = $_GET['driver_id'];
        }

        $sql .= " ORDER BY frequency_score DESC, last_used DESC";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        $routes = $stmt->fetchAll();
        
        echo json_encode($routes);
    } else {
        // Los métodos POST, PUT, DELETE no se exponen, ya que esta tabla se gestiona internamente.
        http_response_code(405); // Method Not Allowed
        echo json_encode(['message' => 'Este recurso es de solo lectura vía API. Las rutas se aprenden automáticamente.']);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>