<?php
// /api/driver_profiles.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            if (!isset($_GET['user_id'])) {
                http_response_code(400); echo json_encode(['message' => 'user_id es requerido.']); exit();
            }
            $stmt = $pdo->prepare("SELECT * FROM Driver_Profiles WHERE user_id = ?");
            $stmt->execute([$_GET['user_id']]);
            $profile = $stmt->fetch();
            if ($profile) echo json_encode($profile);
            else { http_response_code(404); echo json_encode(['message' => 'Perfil de conductor no encontrado.']); }
            break;

        case 'POST': // Generalmente se crea junto con el usuario o al solicitar ser conductor
            $data = getJsonInput();
            $sql = "INSERT INTO Driver_Profiles (user_id, address, id_card_number, id_card_photo_url, selfie_photo_url, emergency_contact_name, emergency_contact_phone) VALUES (?, ?, ?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $data['user_id'], $data['address'], $data['id_card_number'],
                $data['id_card_photo_url'], $data['selfie_photo_url'],
                $data['emergency_contact_name'], $data['emergency_contact_phone']
            ]);
            http_response_code(201);
            echo json_encode(['message' => 'Perfil de conductor creado.']);
            break;

        case 'PUT':
            if (!isset($_GET['user_id'])) { http_response_code(400); echo json_encode(['message' => 'user_id es requerido.']); exit(); }
            $user_id = $_GET['user_id'];
            $data = getJsonInput();
            $allowed = ['address', 'id_card_photo_url', 'selfie_photo_url', 'verification_status', 'rejection_reason', 'emergency_contact_name', 'emergency_contact_phone', 'is_active', 'last_location_lat', 'last_location_lng'];
            $set_parts = [];
            $values = [];
            foreach ($data as $key => $value) {
                if (in_array($key, $allowed)) {
                    $set_parts[] = "$key = ?";
                    $values[] = $value;
                }
            }
            if (empty($set_parts)) { http_response_code(400); echo json_encode(['message' => 'Ningún campo válido para actualizar.']); exit(); }
            
            $sql = "UPDATE Driver_Profiles SET " . implode(', ', $set_parts) . " WHERE user_id = ?";
            $values[] = $user_id;
            $stmt = $pdo->prepare($sql);
            $stmt->execute($values);
            echo json_encode(['message' => 'Perfil de conductor actualizado.']);
            break;

        case 'DELETE':
            if (!isset($_GET['user_id'])) { http_response_code(400); echo json_encode(['message' => 'user_id es requerido.']); exit(); }
            $stmt = $pdo->prepare("DELETE FROM Driver_Profiles WHERE user_id = ?");
            $stmt->execute([$_GET['user_id']]);
            echo json_encode(['message' => 'Perfil de conductor eliminado.']);
            break;

        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>