<?php
// /api/driver_wallets.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            if (!isset($_GET['driver_id'])) {
                http_response_code(400); echo json_encode(['message' => 'driver_id es requerido.']); exit();
            }
            $stmt = $pdo->prepare("SELECT * FROM Driver_Wallets WHERE driver_id = ?");
            $stmt->execute([$_GET['driver_id']]);
            $wallet = $stmt->fetch();
            if ($wallet) {
                echo json_encode($wallet);
            } else {
                http_response_code(404);
                echo json_encode(['message' => 'Billetera de conductor no encontrada.']);
            }
            break;

        case 'POST':
            // Las billeteras se crean automáticamente cuando un usuario se convierte en conductor
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido. Las billeteras se crean automáticamente.']);
            break;

        case 'PUT':
            // Para actualizar los datos bancarios del conductor
            if (!isset($_GET['driver_id'])) { http_response_code(400); echo json_encode(['message' => 'driver_id es requerido.']); exit(); }
            $driver_id = $_GET['driver_id'];
            $data = getJsonInput();
            
            $allowed = ['bank_account_number', 'bank_name', 'account_holder_name'];
            $set_parts = [];
            $values = [];
            foreach ($data as $key => $value) {
                if (in_array($key, $allowed)) {
                    $set_parts[] = "$key = ?";
                    $values[] = $value;
                }
            }
            if (empty($set_parts)) { http_response_code(400); echo json_encode(['message' => 'Ningún campo válido para actualizar.']); exit(); }
            
            $sql = "UPDATE Driver_Wallets SET " . implode(', ', $set_parts) . " WHERE driver_id = ?";
            $values[] = $driver_id;
            $stmt = $pdo->prepare($sql);
            $stmt->execute($values);
            echo json_encode(['message' => 'Datos bancarios actualizados.']);
            break;

        case 'DELETE':
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido. Las billeteras no se pueden eliminar.']);
            break;

        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>