<?php
// /api/email_verification_tokens.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            // Por seguridad, no se debería poder consultar tokens directamente
            http_response_code(403);
            echo json_encode(['message' => 'Acceso denegado.']);
            break;

        case 'POST':
            // Para generar un nuevo token
            $data = getJsonInput();
            if (empty($data['user_id'])) {
                http_response_code(400); echo json_encode(['message' => 'user_id es requerido.']); exit();
            }
            $token = bin2hex(random_bytes(32));
            $expires_at = date('Y-m-d H:i:s', time() + 3600); // 1 hora de validez
            $sql = "INSERT INTO Email_Verification_Tokens (user_id, token, expires_at) VALUES (?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$data['user_id'], $token, $expires_at]);
            
            // Aquí iría la lógica para enviar el email con el token
            // mail($user_email, "Verifica tu correo", "Tu token es: $token");
            
            http_response_code(201);
            echo json_encode(['message' => 'Token de verificación generado y enviado.']);
            break;

        case 'PUT':
             //Endpoint para verificar un token. Ej: PUT /api/email_verification_tokens.php?token=...
            if (!isset($_GET['token'])) { http_response_code(400); echo json_encode(['message' => 'Token no especificado.']); exit(); }
            $token = $_GET['token'];

            $pdo->beginTransaction();

            // 1. Encontrar el token
            $stmt_find = $pdo->prepare("SELECT * FROM Email_Verification_Tokens WHERE token = ? AND used_at IS NULL AND expires_at > NOW()");
            $stmt_find->execute([$token]);
            $token_data = $stmt_find->fetch();

            if (!$token_data) {
                $pdo->rollBack();
                http_response_code(400);
                echo json_encode(['message' => 'Token inválido, expirado o ya utilizado.']);
                exit;
            }

            // 2. Marcar el token como usado
            $stmt_use = $pdo->prepare("UPDATE Email_Verification_Tokens SET used_at = NOW() WHERE id = ?");
            $stmt_use->execute([$token_data['id']]);

            // 3. Marcar el usuario como verificado
            $stmt_verify_user = $pdo->prepare("UPDATE Users SET email_verified = 1 WHERE id = ?");
            $stmt_verify_user->execute([$token_data['user_id']]);

            $pdo->commit();

            echo json_encode(['message' => 'Email verificado correctamente.']);
            break;
            
        case 'DELETE':
        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    if($pdo->inTransaction()) $pdo->rollBack();
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>