<?php
// /api/messages.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            if (!isset($_GET['chat_id'])) {
                http_response_code(400); echo json_encode(['message' => 'chat_id es requerido.']); exit();
            }
            // Obtener todos los mensajes de un chat, ordenados cronológicamente
            $sql = "SELECT * FROM Messages WHERE chat_id = ? ORDER BY sent_at ASC";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$_GET['chat_id']]);
            echo json_encode($stmt->fetchAll());
            break;

        case 'POST':
            $data = getJsonInput();
            if (empty($data['chat_id']) || empty($data['sender_id']) || empty($data['message_content'])) {
                http_response_code(400); echo json_encode(['message' => 'chat_id, sender_id y message_content son requeridos.']); exit();
            }

            $pdo->beginTransaction();
            // 1. Insertar el mensaje
            $sql = "INSERT INTO Messages (chat_id, sender_id, message_content, message_type) VALUES (?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $data['chat_id'],
                $data['sender_id'],
                $data['message_content'],
                $data['message_type'] ?? 'text'
            ]);
            $messageId = $pdo->lastInsertId();

            // 2. Actualizar el timestamp del chat padre
            $stmt_update_chat = $pdo->prepare("UPDATE Chats SET last_message_at = NOW() WHERE id = ?");
            $stmt_update_chat->execute([$data['chat_id']]);

            $pdo->commit();

            http_response_code(201);
            echo json_encode(['message' => 'Mensaje enviado.', 'id' => $messageId]);
            break;

        case 'PUT':
            // Para marcar mensajes como leídos
            if (!isset($_GET['id'])) { http_response_code(400); echo json_encode(['message' => 'ID no especificado.']); exit(); }
            $sql = "UPDATE Messages SET is_read = 1 WHERE id = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$_GET['id']]);
            echo json_encode(['message' => 'Mensaje marcado como leído.']);
            break;

        case 'DELETE':
            // Los usuarios generalmente no pueden borrar mensajes en un chat de viaje
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;

        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>