<?php
// /api/notifications.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            if (!isset($_GET['user_id'])) {
                http_response_code(400); echo json_encode(['message' => 'user_id es requerido.']); exit();
            }
            // Obtener notificaciones no leídas para un usuario
            $sql = "SELECT * FROM Notifications WHERE user_id = ? AND is_read = 0 ORDER BY created_at DESC";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$_GET['user_id']]);
            echo json_encode($stmt->fetchAll());
            break;

        case 'POST': // Generalmente se crean por lógica interna, no por API pública
            $data = getJsonInput();
            $sql = "INSERT INTO Notifications (user_id, title, message, notification_type) VALUES (?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$data['user_id'], $data['title'], $data['message'], $data['notification_type']]);
            http_response_code(201);
            echo json_encode(['message' => 'Notificación creada.', 'id' => $pdo->lastInsertId()]);
            break;

        case 'PUT':
            // Para marcar como leída
            if (isset($_GET['id'])) { // Marcar una específica
                $sql = "UPDATE Notifications SET is_read = 1, read_at = NOW() WHERE id = ?";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([$_GET['id']]);
                echo json_encode(['message' => 'Notificación marcada como leída.']);
            } elseif (isset($_GET['user_id'])) { // Marcar todas las de un usuario
                $sql = "UPDATE Notifications SET is_read = 1, read_at = NOW() WHERE user_id = ? AND is_read = 0";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([$_GET['user_id']]);
                echo json_encode(['message' => 'Todas las notificaciones marcadas como leídas.']);
            } else {
                http_response_code(400); echo json_encode(['message' => 'Se requiere id o user_id.']);
            }
            break;
            
        case 'DELETE':
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;

        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>