<?php
// /api/price_suggestions_cache.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    if ($method == 'GET') {
        $sql = "SELECT * FROM Price_Suggestions_Cache";
        $params = [];
        $conditions = [];

        // Permite buscar un precio sugerido para una ruta, día y hora específicos
        if (isset($_GET['route_hash'])) {
            $conditions[] = "route_hash = ?";
            $params[] = $_GET['route_hash'];
        }
        if (isset($_GET['day_of_week'])) {
            $conditions[] = "day_of_week = ?";
            $params[] = $_GET['day_of_week'];
        }
        if (isset($_GET['time_slot'])) {
            $conditions[] = "time_slot = ?";
            $params[] = $_GET['time_slot'];
        }

        if (!empty($conditions)) {
            $sql .= " WHERE " . implode(' AND ', $conditions);
        }

        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        $suggestions = $stmt->fetchAll();

        echo json_encode($suggestions);
    } else {
        // POST, PUT, DELETE no son necesarios, ya que un proceso batch gestiona la caché.
        http_response_code(405); // Method Not Allowed
        echo json_encode(['message' => 'Este recurso es de solo lectura vía API. El caché de precios se actualiza automáticamente.']);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>