<?php
// /api/support_tickets.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            $sql = "SELECT * FROM Support_Tickets";
            $params = [];
            if (isset($_GET['id'])) {
                $sql .= " WHERE id = ?";
                $params[] = $_GET['id'];
            } elseif (isset($_GET['user_id'])) {
                $sql .= " WHERE user_id = ?";
                $params[] = $_GET['user_id'];
            }
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            echo json_encode($stmt->fetchAll());
            break;

        case 'POST':
            $data = getJsonInput();
            $ticket_number = 'ST-' . time(); // Generador simple de número de ticket
            $sql = "INSERT INTO Support_Tickets (ticket_number, user_id, related_trip_id, related_booking_id, issue_type, title, description) VALUES (?, ?, ?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $ticket_number, $data['user_id'], $data['related_trip_id'] ?? null,
                $data['related_booking_id'] ?? null, $data['issue_type'],
                $data['title'], $data['description']
            ]);
            http_response_code(201);
            echo json_encode(['message' => 'Ticket de soporte creado.', 'id' => $pdo->lastInsertId(), 'ticket_number' => $ticket_number]);
            break;

        case 'PUT': // Para que un admin actualice el estado
            if (!isset($_GET['id'])) { http_response_code(400); echo json_encode(['message' => 'ID no especificado.']); exit(); }
            $id = $_GET['id'];
            $data = getJsonInput();
            $sql = "UPDATE Support_Tickets SET status = ?, priority = ?, assigned_to = ?, admin_notes = ?, resolution_notes = ? WHERE id = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $data['status'], $data['priority'] ?? null, $data['assigned_to'] ?? null,
                $data['admin_notes'] ?? null, $data['resolution_notes'] ?? null, $id
            ]);
            echo json_encode(['message' => 'Ticket actualizado.']);
            break;

        case 'DELETE':
            http_response_code(405); // No se deben borrar tickets
            echo json_encode(['message' => 'Método no permitido.']);
            break;

        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>