<?php
// /api/system_settings.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            if (isset($_GET['key'])) {
                $stmt = $pdo->prepare("SELECT * FROM System_Settings WHERE setting_key = ?");
                $stmt->execute([$_GET['key']]);
                $setting = $stmt->fetch();
                if ($setting) echo json_encode($setting);
                else { http_response_code(404); echo json_encode(['message' => 'Configuración no encontrada.']); }
            } else {
                // Obtener solo las públicas
                $stmt = $pdo->query("SELECT * FROM System_Settings WHERE is_public = 1");
                $settings = $stmt->fetchAll();
                echo json_encode($settings);
            }
            break;
        
        // POST es para crear nuevas configuraciones, solo para admins.
        case 'POST':
            $data = getJsonInput();
            $sql = "INSERT INTO System_Settings (setting_key, setting_value, setting_type, description, is_public) VALUES (?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$data['setting_key'], $data['setting_value'], $data['setting_type'], $data['description'], $data['is_public'] ?? 0]);
            http_response_code(201);
            echo json_encode(['message' => 'Configuración creada.']);
            break;

        // PUT para actualizar una configuración existente.
        case 'PUT':
            if (!isset($_GET['key'])) { http_response_code(400); echo json_encode(['message' => 'Key no especificada.']); exit(); }
            $key = $_GET['key'];
            $data = getJsonInput();
            $sql = "UPDATE System_Settings SET setting_value = ? WHERE setting_key = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$data['setting_value'], $key]);
            echo json_encode(['message' => 'Configuración actualizada.']);
            break;
            
        case 'DELETE':
            if (!isset($_GET['key'])) { http_response_code(400); echo json_encode(['message' => 'Key no especificada.']); exit(); }
            $key = $_GET['key'];
            $stmt = $pdo->prepare("DELETE FROM System_Settings WHERE setting_key = ?");
            $stmt->execute([$key]);
            echo json_encode(['message' => 'Configuración eliminada.']);
            break;

        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>