<?php
// /api/trip_routines.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            $sql = "SELECT * FROM Trip_Routines";
            $params = [];
            if (isset($_GET['id'])) {
                $sql .= " WHERE id = ?";
                $params[] = $_GET['id'];
            } elseif (isset($_GET['driver_id'])) {
                $sql .= " WHERE driver_id = ?";
                $params[] = $_GET['driver_id'];
            }
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            echo json_encode($stmt->fetchAll());
            break;

        case 'POST':
            $data = getJsonInput();
            $sql = "INSERT INTO Trip_Routines (driver_id, vehicle_id, routine_name, direction, departure_time, total_seats, price_per_seat, recurrence_pattern, start_date, end_date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $data['driver_id'], $data['vehicle_id'], $data['routine_name'],
                $data['direction'], $data['departure_time'], $data['total_seats'],
                $data['price_per_seat'], $data['recurrence_pattern'], $data['start_date'], $data['end_date']
            ]);
            http_response_code(201);
            echo json_encode(['message' => 'Rutina creada.', 'id' => $pdo->lastInsertId()]);
            break;

        case 'PUT':
            if (!isset($_GET['id'])) { http_response_code(400); echo json_encode(['message' => 'ID no especificado.']); exit(); }
            $id = $_GET['id'];
            $data = getJsonInput();
            $allowed = ['routine_name', 'departure_time', 'total_seats', 'price_per_seat', 'recurrence_pattern', 'start_date', 'end_date', 'is_active'];
            $set_parts = [];
            $values = [];
            foreach ($data as $key => $value) {
                if (in_array($key, $allowed)) {
                    $set_parts[] = "$key = ?";
                    $values[] = $value;
                }
            }
            if (empty($set_parts)) { http_response_code(400); echo json_encode(['message' => 'Ningún campo válido para actualizar.']); exit(); }
            $sql = "UPDATE Trip_Routines SET " . implode(', ', $set_parts) . " WHERE id = ?";
            $values[] = $id;
            $stmt = $pdo->prepare($sql);
            $stmt->execute($values);
            echo json_encode(['message' => 'Rutina actualizada.']);
            break;

        case 'DELETE':
            if (!isset($_GET['id'])) { http_response_code(400); echo json_encode(['message' => 'ID no especificado.']); exit(); }
            $stmt = $pdo->prepare("DELETE FROM Trip_Routines WHERE id = ?");
            $stmt->execute([$_GET['id']]);
            echo json_encode(['message' => 'Rutina eliminada.']);
            break;

        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>