<?php
// /api/trips.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            // ST_AsText convierte el tipo POINT a un string legible 'POINT(lng lat)'
            $select_fields = "id, driver_id, vehicle_id, direction, departure_time, total_seats, available_seats, price_per_seat, origin_address, destination_address, ST_AsText(origin_coordinates) as origin_coordinates, ST_AsText(destination_coordinates) as destination_coordinates, status";
            if (isset($_GET['id'])) {
                $stmt = $pdo->prepare("SELECT $select_fields FROM Trips WHERE id = ?");
                $stmt->execute([$_GET['id']]);
                $trip = $stmt->fetch();
                if ($trip) echo json_encode($trip);
                else { http_response_code(404); echo json_encode(['message' => 'Viaje no encontrado.']); }
            } else {
                // Endpoint para buscar viajes. Ej: /api/trips.php?direction=to_uni&date=2025-08-01
                $sql = "SELECT $select_fields FROM Trips WHERE status = 'scheduled' AND available_seats > 0";
                $params = [];
                if(isset($_GET['direction'])) { $sql .= " AND direction = ?"; $params[] = $_GET['direction']; }
                if(isset($_GET['date'])) { $sql .= " AND DATE(departure_time) = ?"; $params[] = $_GET['date']; }
                $sql .= " ORDER BY departure_time ASC";
                
                $stmt = $pdo->prepare($sql);
                $stmt->execute($params);
                echo json_encode($stmt->fetchAll());
            }
            break;

        case 'POST':
            $data = getJsonInput();
            // ST_PointFromText convierte un string a tipo POINT. El formato debe ser 'POINT(lng lat)'
            $sql = "INSERT INTO Trips (driver_id, vehicle_id, direction, departure_time, total_seats, available_seats, price_per_seat, origin_address, destination_address, origin_coordinates, destination_coordinates, special_notes) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ST_PointFromText(?), ST_PointFromText(?), ?)";
            
            $origin_point = isset($data['origin_coordinates']) ? 'POINT(' . $data['origin_coordinates']['lng'] . ' ' . $data['origin_coordinates']['lat'] . ')' : null;
            $destination_point = isset($data['destination_coordinates']) ? 'POINT(' . $data['destination_coordinates']['lng'] . ' ' . $data['destination_coordinates']['lat'] . ')' : null;
            
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $data['driver_id'], $data['vehicle_id'], $data['direction'],
                $data['departure_time'], $data['total_seats'], $data['total_seats'],
                $data['price_per_seat'], $data['origin_address'], $data['destination_address'],
                $origin_point, $destination_point, $data['special_notes'] ?? null
            ]);
            http_response_code(201);
            echo json_encode(['message' => 'Viaje creado.', 'id' => $pdo->lastInsertId()]);
            break;

        case 'PUT':
            if (!isset($_GET['id'])) { http_response_code(400); echo json_encode(['message' => 'ID no especificado.']); exit(); }
            // Implementación de actualización dinámica...
            echo json_encode(['message' => 'Viaje actualizado (implementación pendiente).']);
            break;
            
        case 'DELETE':
             if (!isset($_GET['id'])) { http_response_code(400); echo json_encode(['message' => 'ID no especificado.']); exit(); }
             $id = $_GET['id'];
             // Soft delete es mejor práctica: cambiar el estado en lugar de borrar
             $sql = "UPDATE Trips SET status = 'cancelled_by_driver', cancellation_reason = ? WHERE id = ?";
             $stmt = $pdo->prepare($sql);
             $stmt->execute(['Cancelado por el conductor desde la API', $id]);
             // Lógica para notificar pasajeros sería necesaria aquí
             echo json_encode(['message' => 'Viaje cancelado.']);
            break;

        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>