<?php
// /api/users.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            $select_fields = "id, full_name, uniguajira_email, phone_number, profile_picture_url, user_type, is_active, email_verified, last_login, created_at";
            if (isset($_GET['id'])) {
                $stmt = $pdo->prepare("SELECT $select_fields FROM Users WHERE id = ?");
                $stmt->execute([$_GET['id']]);
                $user = $stmt->fetch();
                if ($user) echo json_encode($user);
                else { http_response_code(404); echo json_encode(['message' => 'Usuario no encontrado.']); }
            } else {
                $stmt = $pdo->query("SELECT $select_fields FROM Users");
                echo json_encode($stmt->fetchAll());
            }
            break;

        case 'POST':
            $data = getJsonInput();
            if (empty($data['uniguajira_email']) || empty($data['password'])) {
                http_response_code(400); echo json_encode(['message' => 'Email y contraseña son requeridos.']); exit();
            }
            $password_hash = password_hash($data['password'], PASSWORD_BCRYPT);
            $sql = "INSERT INTO Users (full_name, uniguajira_email, phone_number, password_hash, user_type) VALUES (?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$data['full_name'], $data['uniguajira_email'], $data['phone_number'], $password_hash, $data['user_type'] ?? 'passenger']);
            http_response_code(201);
            echo json_encode(['message' => 'Usuario creado.', 'id' => $pdo->lastInsertId()]);
            break;

        case 'PUT':
            if (!isset($_GET['id'])) { http_response_code(400); echo json_encode(['message' => 'ID no especificado.']); exit(); }
            $id = $_GET['id'];
            $data = getJsonInput();
            $allowed = ['full_name', 'phone_number', 'profile_picture_url', 'user_type', 'is_active'];
            $set_parts = [];
            $values = [];
            foreach ($data as $key => $value) {
                if (in_array($key, $allowed)) { $set_parts[] = "$key = ?"; $values[] = $value; }
                if ($key === 'password' && !empty($value)) { $set_parts[] = "password_hash = ?"; $values[] = password_hash($value, PASSWORD_BCRYPT); }
            }
            if (empty($set_parts)) { http_response_code(400); echo json_encode(['message' => 'Ningún campo válido para actualizar.']); exit(); }
            $sql = "UPDATE Users SET " . implode(', ', $set_parts) . " WHERE id = ?";
            $values[] = $id;
            $stmt = $pdo->prepare($sql);
            $stmt->execute($values);
            echo json_encode(['message' => 'Usuario actualizado.']);
            break;

        case 'DELETE':
            if (!isset($_GET['id'])) { http_response_code(400); echo json_encode(['message' => 'ID no especificado.']); exit(); }
            $stmt = $pdo->prepare("DELETE FROM Users WHERE id = ?");
            $stmt->execute([$_GET['id']]);
            echo json_encode(['message' => 'Usuario eliminado (y datos relacionados por cascada).']);
            break;

        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>