<?php
// /api/vehicles.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            $sql = "SELECT * FROM Vehicles";
            $params = [];
            if (isset($_GET['id'])) {
                $sql .= " WHERE id = ?";
                $params[] = $_GET['id'];
            } elseif (isset($_GET['driver_id'])) {
                $sql .= " WHERE driver_id = ?";
                $params[] = $_GET['driver_id'];
            }
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            echo json_encode($stmt->fetchAll());
            break;

        case 'POST':
            $data = getJsonInput();
            $sql = "INSERT INTO Vehicles (driver_id, plate_number, plate_photo_url, brand, model, year, color, capacity, vehicle_type, soat_expiry, tech_review_expiry) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $data['driver_id'], $data['plate_number'], $data['plate_photo_url'],
                $data['brand'], $data['model'], $data['year'], $data['color'],
                $data['capacity'] ?? 4, $data['vehicle_type'] ?? 'sedan',
                $data['soat_expiry'] ?? null, $data['tech_review_expiry'] ?? null
            ]);
            http_response_code(201);
            echo json_encode(['message' => 'Vehículo creado.', 'id' => $pdo->lastInsertId()]);
            break;

        case 'PUT':
            if (!isset($_GET['id'])) { http_response_code(400); echo json_encode(['message' => 'ID no especificado.']); exit(); }
            $id = $_GET['id'];
            $data = getJsonInput();
            $allowed = ['plate_photo_url', 'brand', 'model', 'year', 'color', 'capacity', 'vehicle_type', 'soat_expiry', 'tech_review_expiry', 'is_active'];
            $set_parts = [];
            $values = [];
            foreach ($data as $key => $value) {
                if (in_array($key, $allowed)) {
                    $set_parts[] = "$key = ?";
                    $values[] = $value;
                }
            }
            if (empty($set_parts)) { http_response_code(400); echo json_encode(['message' => 'Ningún campo válido para actualizar.']); exit(); }
            
            $sql = "UPDATE Vehicles SET " . implode(', ', $set_parts) . " WHERE id = ?";
            $values[] = $id;
            $stmt = $pdo->prepare($sql);
            $stmt->execute($values);
            echo json_encode(['message' => 'Vehículo actualizado.']);
            break;

        case 'DELETE':
            if (!isset($_GET['id'])) { http_response_code(400); echo json_encode(['message' => 'ID no especificado.']); exit(); }
            $stmt = $pdo->prepare("DELETE FROM Vehicles WHERE id = ?");
            $stmt->execute([$_GET['id']]);
            echo json_encode(['message' => 'Vehículo eliminado.']);
            break;

        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>