<?php
// /api/wallet_transactions.php
require_once 'db_config.php';
setApiHeaders();
$pdo = getDbConnection();
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            $sql = "SELECT * FROM Wallet_Transactions";
            $params = [];
            if (isset($_GET['wallet_id'])) { // wallet_id es el driver_id
                $sql .= " WHERE wallet_id = ?";
                $params[] = $_GET['wallet_id'];
            } elseif (isset($_GET['booking_id'])) {
                $sql .= " WHERE booking_id = ?";
                $params[] = $_GET['booking_id'];
            }
            $sql .= " ORDER BY created_at DESC";
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            echo json_encode($stmt->fetchAll());
            break;
        
        case 'POST':
            // Para ajustes manuales por parte de un admin
            $data = getJsonInput();
            if (empty($data['wallet_id']) || empty($data['amount']) || empty($data['transaction_type']) || empty($data['description'])) {
                http_response_code(400); echo json_encode(['message' => 'Faltan campos requeridos.']); exit();
            }
            // Esto debería estar protegido y solo para admins
            $sql = "INSERT INTO Wallet_Transactions (wallet_id, transaction_reference, amount, transaction_type, description, status) VALUES (?, ?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $data['wallet_id'],
                'ADJ-' . time(), // Referencia de ajuste
                $data['amount'],
                $data['transaction_type'],
                $data['description'],
                'completed'
            ]);
            // IMPORTANTE: Aquí también se debería actualizar el balance en Driver_Wallets
            // $updateWalletSql = "UPDATE Driver_Wallets SET balance = balance + ? WHERE driver_id = ?";
            // ...
            http_response_code(201);
            echo json_encode(['message' => 'Transacción de ajuste creada.']);
            break;

        case 'PUT':
        case 'DELETE':
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido. Las transacciones son inmutables.']);
            break;

        default:
            http_response_code(405);
            echo json_encode(['message' => 'Método no permitido.']);
            break;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['message' => 'Error en la base de datos.', 'error' => $e->getMessage()]);
}
?>